// SanMap.js
// Tool for drawing Google Maps of San Andreas.
// Written by Tim Potze
//
// This is free and unencumbered software released into the public domain.
//
// Anyone is free to copy, modify, publish, use, compile, sell, or
// distribute this software, either in source code form or as a compiled
// binary, for any purpose, commercial or non-commercial, and by any
// means.
//
// In jurisdictions that recognize copyright laws, the author or authors
// of this software dedicate any and all copyright interest in the
// software to the public domain. We make this dedication for the benefit
// of the public at large and to the detriment of our heirs and
// successors. We intend this dedication to be an overt act of
// relinquishment in perpetuity of all present and future rights to this
// software under copyright law.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
// OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//
// For more information, please refer to <http://unlicense.org>
//
function SanMapProjection(){var n=512;this.pixelOrigin_=new google.maps.Point(n/2,n/2),this.pixelsPerLonDegree_=n/360,this.scaleLat=2,this.scaleLng=2,this.fromLatLngToPoint=function(n,t){var i=t||new google.maps.Point(0,0);return i.x=this.pixelOrigin_.x+n.lng()*this.pixelsPerLonDegree_*this.scaleLng,i.y=this.pixelOrigin_.y-n.lat()*this.pixelsPerLonDegree_*this.scaleLat,i},this.fromPointToLatLng=function(n){var i=(n.x-this.pixelOrigin_.x)/this.pixelsPerLonDegree_/this.scaleLng,t=(-n.y+this.pixelOrigin_.y)/this.pixelsPerLonDegree_/this.scaleLat;return new google.maps.LatLng(t,i,!0)}}function SanMapType(n,t,i){this.getImageMapType=function(r){return new google.maps.ImageMapType({getTileUrl:function(n,t){var u=n.x,e=n.y,f=1<<t;if(e<0||e>=f||r!==!0&&(u<0||u>=f))return i(t,-1,-1);for(;u<0;u+=f);return i(t,u%f,e)},tileSize:new google.maps.Size(512,512),maxZoom:t,minZoom:n})}}function SanMap(n,t,i,r,u){var o,s,e,f;if(t!==undefined&&t.length!=0){this.map=new google.maps.Map(document.getElementById(n),{zoom:i||2,center:r||SanMap.getLatLngFromPos(0,0),streetViewControl:!1,mapTypeControlOptions:{mapTypeIds:Object.keys(t)}});for(o in t)t.hasOwnProperty(o)&&(s=t[o].getImageMapType(u||!1),s.name=s.alt=o,s.projection=new SanMapProjection,this.map.mapTypes.set(o,s));this.map.setMapTypeId(Object.keys(t)[0]),u||(e=this.map,f=new google.maps.LatLngBounds(new google.maps.LatLng(-90,-90),new google.maps.LatLng(90,90)),google.maps.event.addListener(e,"center_changed",function(){if(!f.contains(e.getCenter())){var t=e.getCenter().lng(),n=e.getCenter().lat();t<f.getSouthWest().lng()&&(t=f.getSouthWest().lng()),t>f.getNorthEast().lng()&&(t=f.getNorthEast().lng()),n<f.getSouthWest().lat()&&(n=f.getSouthWest().lat()),n>f.getNorthEast().lat()&&(n=f.getNorthEast().lat()),e.setCenter(new google.maps.LatLng(n,t))}}))}}SanMap.getLatLngFromPos=function(n,t){return typeof n=="object"?new google.maps.LatLng(n.y/3e3*90,n.x/3e3*90):new google.maps.LatLng(t/3e3*90,n/3e3*90)},SanMap.getPosFromLatLng=function(n){return{x:n.lng()*3e3/90,y:n.lat()*3e3/90}};