// Copyright (C) 2012 Zeex
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#if defined ASM_MACROS_INC
	#endinput
#endif
#define ASM_MACROS_INC

// Only detect ONE space, so you don't need a trailing space on opcodes with no
// parameters. Add a space on the end here incase there wasn't one already.
#define @emit%0\32;%1\10;%3 (asm_emit_haslabel:asm_emit_notlabel:asm_emit_(ctx,%1));

// Detect labels (for jump targets).
#define asm_emit_haslabel:asm_emit_notlabel:asm_emit_(ctx,%1:) AsmEmitLabelStringize AsmEmitLabel:(ctx,%1)
#define asm_emit_notlabel:asm_emit_(ctx,%1) asm_emit_(ctx,%1 )

// Detect jumps to labels, instead of the labels themselves.
#define AsmEmitLabelStringize%0:(ctx,%1\32;%2) asm_emit_%1Label(ctx,%2)
#define AsmEmitLabel:(ctx,%2) (ctx,#%2)

// NOW detect the second space and use it to extract the opcode name.
#define asm_emit_(ctx,%1\32;%2) asm_emit_%1(ctx,%2)

// Finally, detect zero parameters.
#define ctx,) ctx)

// All lower case.
#define asm_emit_add AsmEmitAdd
#define asm_emit_add_c AsmEmitAddC
#define asm_emit_addr_alt AsmEmitAddrAlt
#define asm_emit_addr_pri AsmEmitAddrPri
#define asm_emit_align_alt AsmEmitAlignAlt
#define asm_emit_align_pri AsmEmitAlignPri
#define asm_emit_and AsmEmitAnd
#define asm_emit_bounds AsmEmitBounds
#define asm_emit_break AsmEmitBreak
#define asm_emit_call AsmEmitCall
#define asm_emit_cmps AsmEmitCmps
#define asm_emit_const_alt AsmEmitConstAlt
#define asm_emit_const_pri AsmEmitConstPri
#define asm_emit_dec AsmEmitDec
#define asm_emit_dec_alt AsmEmitDecAlt
#define asm_emit_dec_i AsmEmitDecI
#define asm_emit_dec_pri AsmEmitDecPri
#define asm_emit_dec_s AsmEmitDecS
#define asm_emit_eq AsmEmitEq
#define asm_emit_eq_c_alt AsmEmitEqCAlt
#define asm_emit_eq_c_pri AsmEmitEqCPri
#define asm_emit_fill AsmEmitFill
#define asm_emit_geq AsmEmitGeq
#define asm_emit_grtr AsmEmitGrtr
#define asm_emit_halt AsmEmitHalt
#define asm_emit_heap AsmEmitHeap
#define asm_emit_idxaddr AsmEmitIdxaddr
#define asm_emit_idxaddr_b AsmEmitIdxaddrB
#define asm_emit_inc AsmEmitInc
#define asm_emit_inc_alt AsmEmitIncAlt
#define asm_emit_inc_i AsmEmitIncI
#define asm_emit_inc_pri AsmEmitIncPri
#define asm_emit_inc_s AsmEmitIncS
#define asm_emit_invert AsmEmitInvert
#define asm_emit_jeq AsmEmitJeq
#define asm_emit_jeq_rel AsmEmitJeqRel
#define asm_emit_jgeq AsmEmitJgeq
#define asm_emit_jgeq_rel AsmEmitJgeqRel
#define asm_emit_jgrtr AsmEmitJgrtr
#define asm_emit_jgrtr_rel AsmEmitJgrtrRel
#define asm_emit_jleq AsmEmitJleq
#define asm_emit_jleq_rel AsmEmitJleqRel
#define asm_emit_jless AsmEmitJless
#define asm_emit_jless_rel AsmEmitJlessRel
#define asm_emit_jneq AsmEmitJneq
#define asm_emit_jneq_rel AsmEmitJneqRel
#define asm_emit_jnz AsmEmitJnz
#define asm_emit_jnz_rel AsmEmitJnzRel
#define asm_emit_jsgeq AsmEmitJsgeq
#define asm_emit_jsgeq_rel AsmEmitJsgeqRel
#define asm_emit_jsgrtr AsmEmitJsgrtr
#define asm_emit_jsgrtr_rel AsmEmitJsgrtrRel
#define asm_emit_jsleq AsmEmitJsleq
#define asm_emit_jsleq_rel AsmEmitJsleqRel
#define asm_emit_jsless AsmEmitJsless
#define asm_emit_jsless_rel AsmEmitJslessRel
#define asm_emit_jump AsmEmitJump
#define asm_emit_jump_rel AsmEmitJumpRel
#define asm_emit_jzer AsmEmitJzer
#define asm_emit_jzer_rel AsmEmitJzerRel
#define asm_emit_lctrl AsmEmitLctrl
#define asm_emit_leq AsmEmitLeq
#define asm_emit_less AsmEmitLess
#define asm_emit_lidx AsmEmitLidx
#define asm_emit_lidx_b AsmEmitLidxB
#define asm_emit_load_alt AsmEmitLoadAlt
#define asm_emit_load_i AsmEmitLoadI
#define asm_emit_load_pri AsmEmitLoadPri
#define asm_emit_load_s_alt AsmEmitLoadSAlt
#define asm_emit_load_s_pri AsmEmitLoadSPri
#define asm_emit_lodb_i AsmEmitLodbI
#define asm_emit_lref_alt AsmEmitLrefAlt
#define asm_emit_lref_pri AsmEmitLrefPri
#define asm_emit_lref_s_alt AsmEmitLrefSAlt
#define asm_emit_lref_s_pri AsmEmitLrefSPri
#define asm_emit_move_alt AsmEmitMoveAlt
#define asm_emit_move_pri AsmEmitMovePri
#define asm_emit_movs AsmEmitMovs
#define asm_emit_neg AsmEmitNeg
#define asm_emit_neq AsmEmitNeq
#define asm_emit_nop AsmEmitNop
#define asm_emit_not AsmEmitNot
#define asm_emit_or AsmEmitOr
#define asm_emit_pop_alt AsmEmitPopAlt
#define asm_emit_pop_pri AsmEmitPopPri
#define asm_emit_proc AsmEmitProc
#define asm_emit_push AsmEmitPush
#define asm_emit_push_adr AsmEmitPushAdr
#define asm_emit_push_alt AsmEmitPushAlt
#define asm_emit_push_c AsmEmitPushC
#define asm_emit_push_pri AsmEmitPushPri
#define asm_emit_push_s AsmEmitPushS
#define asm_emit_ret AsmEmitRet
#define asm_emit_retn AsmEmitRetn
#define asm_emit_sctrl AsmEmitSctrl
#define asm_emit_sdiv AsmEmitSdiv
#define asm_emit_sdiv_alt AsmEmitSdivAlt
#define asm_emit_sgeq AsmEmitSgeq
#define asm_emit_sgrtr AsmEmitSgrtr
#define asm_emit_shl AsmEmitShl
#define asm_emit_shl_c_alt AsmEmitShlCAlt
#define asm_emit_shl_c_pri AsmEmitShlCPri
#define asm_emit_shr AsmEmitShr
#define asm_emit_shr_c_alt AsmEmitShrCAlt
#define asm_emit_shr_c_pri AsmEmitShrCPri
#define asm_emit_sign_alt AsmEmitSignAlt
#define asm_emit_sign_pri AsmEmitSignPri
#define asm_emit_sleq AsmEmitSleq
#define asm_emit_sless AsmEmitSless
#define asm_emit_smul AsmEmitSmul
#define asm_emit_smul_c AsmEmitSmulC
#define asm_emit_sref_alt AsmEmitSrefAlt
#define asm_emit_sref_pri AsmEmitSrefPri
#define asm_emit_sref_s_alt AsmEmitSrefSAlt
#define asm_emit_sref_s_pri AsmEmitSrefSPri
#define asm_emit_sshr AsmEmitSshr
#define asm_emit_stack AsmEmitStack
#define asm_emit_stor_alt AsmEmitStorAlt
#define asm_emit_stor_i AsmEmitStorI
#define asm_emit_stor_pri AsmEmitStorPri
#define asm_emit_stor_s_alt AsmEmitStorSAlt
#define asm_emit_stor_s_pri AsmEmitStorSPri
#define asm_emit_strb_i AsmEmitStrbI
#define asm_emit_sub AsmEmitSub
#define asm_emit_sub_alt AsmEmitSubAlt
#define asm_emit_swap_alt AsmEmitSwapAlt
#define asm_emit_swap_pri AsmEmitSwapPri
#define asm_emit_sysreq_c AsmEmitSysreqC
#define asm_emit_sysreq_d AsmEmitSysreqD
#define asm_emit_udiv AsmEmitUdiv
#define asm_emit_udiv_alt AsmEmitUdivAlt
#define asm_emit_umul AsmEmitUmul
#define asm_emit_xchg AsmEmitXchg
#define asm_emit_xor AsmEmitXor
#define asm_emit_zero AsmEmitZero
#define asm_emit_zero_alt AsmEmitZeroAlt
#define asm_emit_zero_pri AsmEmitZeroPri
#define asm_emit_zero_s AsmEmitZeroS
// Custom.
#define asm_emit_sysreq AsmEmitSysreq
#define asm_emit_pop_args AsmEmitPopArgs
#define asm_emit_push_arg AsmEmitPushArg
#define asm_emit_push_num_args AsmEmitPushNumArgs

// All UPPER case.
#define asm_emit_ADD AsmEmitAdd
#define asm_emit_AND AsmEmitAnd
#define asm_emit_BOUNDS AsmEmitBounds
#define asm_emit_BREAK AsmEmitBreak
#define asm_emit_CALL AsmEmitCall
#define asm_emit_CMPS AsmEmitCmps
#define asm_emit_DEC AsmEmitDec
#define asm_emit_EQ AsmEmitEq
#define asm_emit_FILL AsmEmitFill
#define asm_emit_GEQ AsmEmitGeq
#define asm_emit_GRTR AsmEmitGrtr
#define asm_emit_HALT AsmEmitHalt
#define asm_emit_HEAP AsmEmitHeap
#define asm_emit_IDXADDR AsmEmitIdxaddr
#define asm_emit_INC AsmEmitInc
#define asm_emit_INVERT AsmEmitInvert
#define asm_emit_JEQ AsmEmitJeq
#define asm_emit_JGEQ AsmEmitJgeq
#define asm_emit_JGRTR AsmEmitJgrtr
#define asm_emit_JLEQ AsmEmitJleq
#define asm_emit_JLESS AsmEmitJless
#define asm_emit_JNEQ AsmEmitJneq
#define asm_emit_JNZ AsmEmitJnz
#define asm_emit_JSGEQ AsmEmitJsgeq
#define asm_emit_JSGRTR AsmEmitJsgrtr
#define asm_emit_JSLEQ AsmEmitJsleq
#define asm_emit_JSLESS AsmEmitJsless
#define asm_emit_JUMP AsmEmitJump
#define asm_emit_JZER AsmEmitJzer
#define asm_emit_LCTRL AsmEmitLctrl
#define asm_emit_LEQ AsmEmitLeq
#define asm_emit_LESS AsmEmitLess
#define asm_emit_LIDX AsmEmitLidx
#define asm_emit_MOVS AsmEmitMovs
#define asm_emit_NEG AsmEmitNeg
#define asm_emit_NEQ AsmEmitNeq
#define asm_emit_NOP AsmEmitNop
#define asm_emit_NOT AsmEmitNot
#define asm_emit_OR AsmEmitOr
#define asm_emit_PROC AsmEmitProc
#define asm_emit_PUSH AsmEmitPush
#define asm_emit_RET AsmEmitRet
#define asm_emit_RETN AsmEmitRetn
#define asm_emit_SCTRL AsmEmitSctrl
#define asm_emit_SDIV AsmEmitSdiv
#define asm_emit_SGEQ AsmEmitSgeq
#define asm_emit_SGRTR AsmEmitSgrtr
#define asm_emit_SHL AsmEmitShl
#define asm_emit_SHR AsmEmitShr
#define asm_emit_SLEQ AsmEmitSleq
#define asm_emit_SLESS AsmEmitSless
#define asm_emit_SMUL AsmEmitSmul
#define asm_emit_SSHR AsmEmitSshr
#define asm_emit_STACK AsmEmitStack
#define asm_emit_SUB AsmEmitSub
#define asm_emit_UDIV AsmEmitUdiv
#define asm_emit_UMUL AsmEmitUmul
#define asm_emit_XCHG AsmEmitXchg
#define asm_emit_XOR AsmEmitXor
#define asm_emit_ZERO AsmEmitZero
#define asm_emit_SYSREQ AsmEmitSysreq

// All mixed case.
#define asm_emit_Add AsmEmitAdd
#define asm_emit_And AsmEmitAnd
#define asm_emit_Bounds AsmEmitBounds
#define asm_emit_Break AsmEmitBreak
#define asm_emit_Call AsmEmitCall
#define asm_emit_Cmps AsmEmitCmps
#define asm_emit_Dec AsmEmitDec
#define asm_emit_Eq AsmEmitEq
#define asm_emit_Fill AsmEmitFill
#define asm_emit_Geq AsmEmitGeq
#define asm_emit_Grtr AsmEmitGrtr
#define asm_emit_Halt AsmEmitHalt
#define asm_emit_Heap AsmEmitHeap
#define asm_emit_Idxaddr AsmEmitIdxaddr
#define asm_emit_Inc AsmEmitInc
#define asm_emit_Invert AsmEmitInvert
#define asm_emit_Jeq AsmEmitJeq
#define asm_emit_Jgeq AsmEmitJgeq
#define asm_emit_Jgrtr AsmEmitJgrtr
#define asm_emit_Jleq AsmEmitJleq
#define asm_emit_Jless AsmEmitJless
#define asm_emit_Jneq AsmEmitJneq
#define asm_emit_Jnz AsmEmitJnz
#define asm_emit_Jsgeq AsmEmitJsgeq
#define asm_emit_Jsgrtr AsmEmitJsgrtr
#define asm_emit_Jsleq AsmEmitJsleq
#define asm_emit_Jsless AsmEmitJsless
#define asm_emit_Jump AsmEmitJump
#define asm_emit_Jzer AsmEmitJzer
#define asm_emit_Lctrl AsmEmitLctrl
#define asm_emit_Leq AsmEmitLeq
#define asm_emit_Less AsmEmitLess
#define asm_emit_Lidx AsmEmitLidx
#define asm_emit_Movs AsmEmitMovs
#define asm_emit_Neg AsmEmitNeg
#define asm_emit_Neq AsmEmitNeq
#define asm_emit_Nop AsmEmitNop
#define asm_emit_Not AsmEmitNot
#define asm_emit_Or AsmEmitOr
#define asm_emit_Proc AsmEmitProc
#define asm_emit_Push AsmEmitPush
#define asm_emit_Ret AsmEmitRet
#define asm_emit_Retn AsmEmitRetn
#define asm_emit_Sctrl AsmEmitSctrl
#define asm_emit_Sdiv AsmEmitSdiv
#define asm_emit_Sgeq AsmEmitSgeq
#define asm_emit_Sgrtr AsmEmitSgrtr
#define asm_emit_Shl AsmEmitShl
#define asm_emit_Shr AsmEmitShr
#define asm_emit_Sleq AsmEmitSleq
#define asm_emit_Sless AsmEmitSless
#define asm_emit_Smul AsmEmitSmul
#define asm_emit_Sshr AsmEmitSshr
#define asm_emit_Stack AsmEmitStack
#define asm_emit_Sub AsmEmitSub
#define asm_emit_Udiv AsmEmitUdiv
#define asm_emit_Umul AsmEmitUmul
#define asm_emit_Xchg AsmEmitXchg
#define asm_emit_Xor AsmEmitXor
#define asm_emit_Zero AsmEmitZero
#define asm_emit_Sysreq AsmEmitSysreq

// Now detect all the "." variants.
#define AsmEmitAdd.%0(%1) AsmEmitAdd%0(%1)
#define AsmEmitAddc AsmEmitAddC
#define AsmEmitAddr.%0(%1) AsmEmitAddr%0(%1)
#define AsmEmitAddrpri AsmEmitAddrPri
#define AsmEmitAddrPRI AsmEmitAddrPri
#define AsmEmitAddralt AsmEmitAddrAlt
#define AsmEmitAddrALT AsmEmitAddrAlt
#define AsmEmitAlign.%0(%1) AsmEmitAlign%0(%1)
#define AsmEmitAlignpri AsmEmitAlignPri
#define AsmEmitAlignPRI AsmEmitAlignPri
#define AsmEmitAlignalt AsmEmitAlignaAlt
#define AsmEmitAlignALT AsmEmitAlignaAlt
#define AsmEmitCall.%0(%1) AsmEmitCall%0(%1)
#define AsmEmitCallabs AsmEmitCallAbs
#define AsmEmitConst.%0(%1) AsmEmitConst%0(%1)
#define AsmEmitConstpri AsmEmitConstPri
#define AsmEmitConstPRI AsmEmitConstPri
#define AsmEmitConstalt AsmEmitConstAlt
#define AsmEmitConstALT AsmEmitConstAlt
#define AsmEmitDec.%0(%1) AsmEmitDec%0(%1)
#define AsmEmitDecpri AsmEmitDecPri
#define AsmEmitDecPRI AsmEmitDecPri
#define AsmEmitDecalt AsmEmitDecAlt
#define AsmEmitDecALT AsmEmitDecAlt
#define AsmEmitDeci AsmEmitDecI
#define AsmEmitDecs AsmEmitDecS
#define AsmEmitEq.%0(%1) AsmEmitEq%0(%1)
#define AsmEmitEqc AsmEmitEqC
#define AsmEmitEqC.%0(%1) AsmEmitEqC%0(%1)
#define AsmEmitEqCpri AsmEmitEqCPri
#define AsmEmitEqCPRI AsmEmitEqCPri
#define AsmEmitEqCalt AsmEmitEqCAlt
#define AsmEmitEqCALT AsmEmitEqCAlt
#define AsmEmitIdxaddr.%0(%1) AsmEmitIdxaddr%0(%1)
#define AsmEmitIdxaddrb AsmEmitIdxaddrB
#define AsmEmitInc.%0(%1) AsmEmitInc%0(%1)
#define AsmEmitIncpri AsmEmitIncPri
#define AsmEmitIncPRI AsmEmitIncPri
#define AsmEmitIncalt AsmEmitIncAlt
#define AsmEmitIncALT AsmEmitIncAlt
#define AsmEmitInci AsmEmitIncI
#define AsmEmitIncs AsmEmitIncS
#define AsmEmitJeq.%0(%1) AsmEmitJeq%0(%1)
#define AsmEmitJgeq.%0(%1) AsmEmitJgeq%0(%1)
#define AsmEmitJgrtr.%0(%1) AsmEmitJgrtr%0(%1)
#define AsmEmitJleq.%0(%1) AsmEmitJleq%0(%1)
#define AsmEmitJless.%0(%1) AsmEmitJless%0(%1)
#define AsmEmitJneq.%0(%1) AsmEmitJneq%0(%1)
#define AsmEmitJnz.%0(%1) AsmEmitJnz%0(%1)
#define AsmEmitJsgeq.%0(%1) AsmEmitJsgeq%0(%1)
#define AsmEmitJsgrtr.%0(%1) AsmEmitJsgrtr%0(%1)
#define AsmEmitJsleq.%0(%1) AsmEmitJsleq%0(%1)
#define AsmEmitJsless.%0(%1) AsmEmitJsless%0(%1)
#define AsmEmitJump.%0(%1) AsmEmitJump%0(%1)
#define AsmEmitJzer.%0(%1) AsmEmitJzer%0(%1)
#define AsmEmitJeqrel AsmEmitJeqRel
#define AsmEmitJgeqrel AsmEmitJgeqRel
#define AsmEmitJgrtrrel AsmEmitJgrtrRel
#define AsmEmitJleqrel AsmEmitJleqRel
#define AsmEmitJlessrel AsmEmitJlessRel
#define AsmEmitJneqrel AsmEmitJneqRel
#define AsmEmitJnzrel AsmEmitJnzRel
#define AsmEmitJsgeqrel AsmEmitJsgeqRel
#define AsmEmitJsgrtrrel AsmEmitJsgrtrRel
#define AsmEmitJsleqrel AsmEmitJsleqRel
#define AsmEmitJslessrel AsmEmitJslessRel
#define AsmEmitJumprel AsmEmitJumpRel
#define AsmEmitJzerrel AsmEmitJzerRel
#define AsmEmitJeqREL AsmEmitJeqRel
#define AsmEmitJgeqREL AsmEmitJgeqRel
#define AsmEmitJgrtrREL AsmEmitJgrtrRel
#define AsmEmitJleqREL AsmEmitJleqRel
#define AsmEmitJlessREL AsmEmitJlessRel
#define AsmEmitJneqREL AsmEmitJneqRel
#define AsmEmitJnzREL AsmEmitJnzRel
#define AsmEmitJsgeqREL AsmEmitJsgeqRel
#define AsmEmitJsgrtrREL AsmEmitJsgrtrRel
#define AsmEmitJsleqREL AsmEmitJsleqRel
#define AsmEmitJslessREL AsmEmitJslessRel
#define AsmEmitJumpREL AsmEmitJumpRel
#define AsmEmitJzerREL AsmEmitJzerRel
#define AsmEmitLidx.%0(%1) AsmEmitLidx%0(%1)
#define AsmEmitLidxb AsmEmitLidxB
#define AsmEmitLoad.%0(%1) AsmEmitLoad%0(%1)
#define AsmEmitLoadpri AsmEmitLoadPri
#define AsmEmitLoadPRI AsmEmitLoadPri
#define AsmEmitLoadalt AsmEmitLoadAlt
#define AsmEmitLoadALT AsmEmitLoadAlt
#define AsmEmitLoads AsmEmitLoadS
#define AsmEmitLoadS.%0(%1) AsmEmitLoadS%0(%1)
#define AsmEmitLoadSpri AsmEmitLoadSPri
#define AsmEmitLoadSPRI AsmEmitLoadSPri
#define AsmEmitLoadSalt AsmEmitLoadSAlt
#define AsmEmitLoadSALT AsmEmitLoadSAlt
#define AsmEmitLodb.%0(%1) AsmEmitLodb%0(%1)
#define AsmEmitLodbi AsmEmitLodbI
#define AsmEmitLoadi AsmEmitLoadI
#define AsmEmitLref.%0(%1) AsmEmitLref%0(%1)
#define AsmEmitLrefpri AsmEmitLrefPri
#define AsmEmitLrefPRI AsmEmitLrefPri
#define AsmEmitLrefalt AsmEmitLrefAlt
#define AsmEmitLrefALT AsmEmitLrefAlt
#define AsmEmitLrefs AsmEmitLrefS
#define AsmEmitLrefS.%0(%1) AsmEmitLrefS%0(%1)
#define AsmEmitLrefSpri AsmEmitLrefSPri
#define AsmEmitLrefSPRI AsmEmitLrefSPri
#define AsmEmitLrefSalt AsmEmitLrefSAlt
#define AsmEmitLrefSALT AsmEmitLrefSAlt
#define AsmEmitMove.%0(%1) AsmEmitMove%0(%1)
#define AsmEmitMovepri AsmEmitMovePri
#define AsmEmitMovePRI AsmEmitMovePri
#define AsmEmitMovealt AsmEmitMoveAlt
#define AsmEmitMoveALT AsmEmitMoveAlt
#define AsmEmitPop.%0(%1) AsmEmitPop%0(%1)
#define AsmEmitPoppri AsmEmitPopPri
#define AsmEmitPopPRI AsmEmitPopPri
#define AsmEmitPopalt AsmEmitPopAlt
#define AsmEmitPopALT AsmEmitPopAlt
#define AsmEmitPush.%0(%1) AsmEmitPush%0(%1)
#define AsmEmitPushpri AsmEmitPushPri
#define AsmEmitPushPRI AsmEmitPushPri
#define AsmEmitPushalt AsmEmitPushAlt
#define AsmEmitPushALT AsmEmitPushAlt
#define AsmEmitPushadr AsmEmitPushAdr
#define AsmEmitPushADR AsmEmitPushAdr
#define AsmEmitPushc AsmEmitPushC
#define AsmEmitPushs AsmEmitPushS
#define AsmEmitSdiv.%0(%1) AsmEmitSdiv%0(%1)
#define AsmEmitSdivalt AsmEmitSdivAlt
#define AsmEmitSdivALT AsmEmitSdivAlt
#define AsmEmitShl.%0(%1) AsmEmitShl%0(%1)
#define AsmEmitShlc AsmEmitShlC
#define AsmEmitShlC.%0(%1) AsmEmitShlC%0(%1)
#define AsmEmitShlCpri AsmEmitShlCPri
#define AsmEmitShlCPRI AsmEmitShlCPri
#define AsmEmitShlCalt AsmEmitShlCAlt
#define AsmEmitShlCALT AsmEmitShlCAlt
#define AsmEmitShr.%0(%1) AsmEmitShr%0(%1)
#define AsmEmitShrc AsmEmitShrC
#define AsmEmitShrC.%0(%1) AsmEmitShrC%0(%1)
#define AsmEmitShrCpri AsmEmitShrCPri
#define AsmEmitShrCPRI AsmEmitShrCPri
#define AsmEmitShrCalt AsmEmitShrCAlt
#define AsmEmitShrCALT AsmEmitShrCAlt
#define AsmEmitSign.%0(%1) AsmEmitSign%0(%1)
#define AsmEmitSignpri AsmEmitSignPri
#define AsmEmitSignPRI AsmEmitSignPri
#define AsmEmitSignalt AsmEmitSignAlt
#define AsmEmitSignALT AsmEmitSignAlt
#define AsmEmitSmul.%0(%1) AsmEmitSmul%0(%1)
#define AsmEmitSmulc AsmEmitSmulC
#define AsmEmitSref.%0(%1) AsmEmitSref%0(%1)
#define AsmEmitSrefpri AsmEmitSrefPri
#define AsmEmitSrefPRI AsmEmitSrefPri
#define AsmEmitSrefalt AsmEmitSrefAlt
#define AsmEmitSrefALT AsmEmitSrefAlt
#define AsmEmitSrefs AsmEmitSrefS
#define AsmEmitSrefS.%0(%1) AsmEmitSrefS%0(%1)
#define AsmEmitSrefSpri AsmEmitSrefSPri
#define AsmEmitSrefSPRI AsmEmitSrefSPri
#define AsmEmitSrefSalt AsmEmitSrefSAlt
#define AsmEmitSrefSALT AsmEmitSrefSAlt
#define AsmEmitStor.%0(%1) AsmEmitStor%0(%1)
#define AsmEmitStorpri AsmEmitStorPri
#define AsmEmitStorPRI AsmEmitStorPri
#define AsmEmitStoralt AsmEmitStorAlt
#define AsmEmitStorALT AsmEmitStorAlt
#define AsmEmitStori AsmEmitStorI
#define AsmEmitStors AsmEmitStorS
#define AsmEmitStorS.%0(%1) AsmEmitStorS%0(%1)
#define AsmEmitStorSpri AsmEmitStorSPri
#define AsmEmitStorSPRI AsmEmitStorSPri
#define AsmEmitStorSalt AsmEmitStorSAlt
#define AsmEmitStorSALT AsmEmitStorSAlt
#define AsmEmitStrb.%0(%1) AsmEmitStrb%0(%1)
#define AsmEmitStrbi AsmEmitStrbI
#define AsmEmitSub.%0(%1) AsmEmitSub%0(%1)
#define AsmEmitSubalt AsmEmitSubAlt
#define AsmEmitSubALT AsmEmitSubAlt
#define AsmEmitSwap.%0(%1) AsmEmitSwap%0(%1)
#define AsmEmitSwappri AsmEmitSwapPri
#define AsmEmitSwapPRI AsmEmitSwapPri
#define AsmEmitSwapalt AsmEmitSwapAlt
#define AsmEmitSwapALT AsmEmitSwapAlt
#define AsmEmitSysreq.%0(%1) AsmEmitSysreq%0(%1)
#define AsmEmitSysreqc AsmEmitSysreqC
#define AsmEmitSysreqd AsmEmitSysreqD
#define AsmEmitUdiv.%0(%1) AsmEmitUdiv%0(%1)
#define AsmEmitUdivalt AsmEmitUdivAlt
#define AsmEmitUdivALT AsmEmitUdivAlt
#define AsmEmitZero.%0(%1) AsmEmitZero%0(%1)
#define AsmEmitZeropri AsmEmitZeroPri
#define AsmEmitZeroPRI AsmEmitZeroPri
#define AsmEmitZeroalt AsmEmitZeroAlt
#define AsmEmitZeroALT AsmEmitZeroAlt
#define AsmEmitZeros AsmEmitZeroS
// Custom.
#define AsmEmitPopargs AsmEmitPopArgs
#define AsmEmitPopARGS AsmEmitPopArgs
#define AsmEmitPusharg AsmEmitPushArg
#define AsmEmitPushARG AsmEmitPushArg
#define AsmEmitPushnum AsmEmitPushNum
#define AsmEmitPushNUM AsmEmitPushNum
#define AsmEmitPushNum.%0(%1) AsmEmitPushNum%0(%1)
#define AsmEmitPushNumargs AsmEmitPushNumArgs
#define AsmEmitPushNumARGS AsmEmitPushNumArgs

// Certain OpCodes don't exist, but are the start of others - detect them here.

// Lower-case.
#define asm_emit_addr AsmEmitAddr
#define asm_emit_align AsmEmitAlign
#define asm_emit_const AsmEmitConst
#define asm_emit_load AsmEmitLoad
#define asm_emit_lodb AsmEmitLodb
#define asm_emit_lref AsmEmitLref
#define asm_emit_move AsmEmitMove
#define asm_emit_pop AsmEmitPop
#define asm_emit_sign AsmEmitSign
#define asm_emit_stor AsmEmitStor
#define asm_emit_sref AsmEmitSref
#define asm_emit_strb AsmEmitStrb
#define asm_emit_swap AsmEmitSwap
// Mixed-case.
#define asm_emit_Addr AsmEmitAddr
#define asm_emit_Align AsmEmitAlign
#define asm_emit_Const AsmEmitConst
#define asm_emit_Load AsmEmitLoad
#define asm_emit_Lodb AsmEmitLodb
#define asm_emit_Lref AsmEmitLref
#define asm_emit_Move AsmEmitMove
#define asm_emit_Pop AsmEmitPop
#define asm_emit_Sign AsmEmitSign
#define asm_emit_Stor AsmEmitStor
#define asm_emit_Sref AsmEmitSref
#define asm_emit_Strb AsmEmitStrb
#define asm_emit_Swap AsmEmitSwap
// Upper-case.
#define asm_emit_ADDR AsmEmitAddr
#define asm_emit_ALIGN AsmEmitAlign
#define asm_emit_CONST AsmEmitConst
#define asm_emit_LOAD AsmEmitLoad
#define asm_emit_LODB AsmEmitLodb
#define asm_emit_LREF AsmEmitLref
#define asm_emit_MOVE AsmEmitMove
#define asm_emit_POP AsmEmitPop
#define asm_emit_SIGN AsmEmitSign
#define asm_emit_STOR AsmEmitStor
#define asm_emit_SREF AsmEmitSref
#define asm_emit_STRB AsmEmitStrb
#define asm_emit_SWAP AsmEmitSwap

// Jumps to labels.
#define asm_emit_jeqLabel AsmEmitJeqLabel
#define asm_emit_jeq_labelLabel AsmEmitJeqLabel
#define asm_emit_jgeqLabel AsmEmitJgeqLabel
#define asm_emit_jgeq_labelLabel AsmEmitJgeqLabel
#define asm_emit_jgrtrLabel AsmEmitJgrtrLabel
#define asm_emit_jgrtr_labelLabel AsmEmitJgrtrLabel
#define asm_emit_jleqLabel AsmEmitJleqLabel
#define asm_emit_jleq_labelLabel AsmEmitJleqLabel
#define asm_emit_jlessLabel AsmEmitJlessLabel
#define asm_emit_jless_labelLabel AsmEmitJlessLabel
#define asm_emit_jneqLabel AsmEmitJneqLabel
#define asm_emit_jneq_labelLabel AsmEmitJneqLabel
#define asm_emit_jnzLabel AsmEmitJnzLabel
#define asm_emit_jnz_labelLabel AsmEmitJnzLabel
#define asm_emit_jsgeqLabel AsmEmitJsgeqLabel
#define asm_emit_jsgeq_labelLabel AsmEmitJsgeqLabel
#define asm_emit_jsgrtrLabel AsmEmitJsgrtrLabel
#define asm_emit_jsgrtr_labelLabel AsmEmitJsgrtrLabel
#define asm_emit_jsleqLabel AsmEmitJsleqLabel
#define asm_emit_jsleq_labelLabel AsmEmitJsleqLabel
#define asm_emit_jslessLabel AsmEmitJslessLabel
#define asm_emit_jsless_labelLabel AsmEmitJslessLabel
#define asm_emit_jumpLabel AsmEmitJumpLabel
#define asm_emit_jump_labelLabel AsmEmitJumpLabel
#define asm_emit_jzerLabel AsmEmitJzerLabel
#define asm_emit_jzer_labelLabel AsmEmitJzerLabel

#define asm_emit_jeq_label AsmEmitJeqLabel
#define asm_emit_jgeq_label AsmEmitJgeqLabel
#define asm_emit_jgrtr_label AsmEmitJgrtrLabel
#define asm_emit_jleq_label AsmEmitJleqLabel
#define asm_emit_jless_label AsmEmitJlessLabel
#define asm_emit_jneq_label AsmEmitJneqLabel
#define asm_emit_jnz_label AsmEmitJnzLabel
#define asm_emit_jsgeq_label AsmEmitJsgeqLabel
#define asm_emit_jsgrtr_label AsmEmitJsgrtrLabel
#define asm_emit_jsleq_label AsmEmitJsleqLabel
#define asm_emit_jsless_label AsmEmitJslessLabel
#define asm_emit_jump_label AsmEmitJumpLabel
#define asm_emit_jzer_label AsmEmitJzerLabel

#define asm_emit_JEQLabel AsmEmitJeqLabel
#define asm_emit_JGEQLabel AsmEmitJgeqLabel
#define asm_emit_JGRTRLabel AsmEmitJgrtrLabel
#define asm_emit_JLEQLabel AsmEmitJleqLabel
#define asm_emit_JLESSLabel AsmEmitJlessLabel
#define asm_emit_JNEQLabel AsmEmitJneqLabel
#define asm_emit_JNZLabel AsmEmitJnzLabel
#define asm_emit_JSGEQLabel AsmEmitJsgeqLabel
#define asm_emit_JSGRTRLabel AsmEmitJsgrtrLabel
#define asm_emit_JSLEQLabel AsmEmitJsleqLabel
#define asm_emit_JSLESSLabel AsmEmitJslessLabel
#define asm_emit_JUMPLabel AsmEmitJumpLabel
#define asm_emit_JZERLabel AsmEmitJzerLabel

#define asm_emit_JeqLabel AsmEmitJeqLabel
#define asm_emit_JgeqLabel AsmEmitJgeqLabel
#define asm_emit_JgrtrLabel AsmEmitJgrtrLabel
#define asm_emit_JleqLabel AsmEmitJleqLabel
#define asm_emit_JlessLabel AsmEmitJlessLabel
#define asm_emit_JneqLabel AsmEmitJneqLabel
#define asm_emit_JnzLabel AsmEmitJnzLabel
#define asm_emit_JsgeqLabel AsmEmitJsgeqLabel
#define asm_emit_JsgrtrLabel AsmEmitJsgrtrLabel
#define asm_emit_JsleqLabel AsmEmitJsleqLabel
#define asm_emit_JslessLabel AsmEmitJslessLabel
#define asm_emit_JumpLabel AsmEmitJumpLabel
#define asm_emit_JzerLabel AsmEmitJzerLabel

// Only used when they explicitly typed `@emit JUMP.label x`
#define AsmEmitJeqlabel AsmEmitJeqLabel
#define AsmEmitJgeqlabel AsmEmitJgeqLabel
#define AsmEmitJgrtrlabel AsmEmitJgrtrLabel
#define AsmEmitJleqlabel AsmEmitJleqLabel
#define AsmEmitJlesslabel AsmEmitJlessLabel
#define AsmEmitJneqlabel AsmEmitJneqLabel
#define AsmEmitJnzlabel AsmEmitJnzLabel
#define AsmEmitJsgeqlabel AsmEmitJsgeqLabel
#define AsmEmitJsgrtrlabel AsmEmitJsgrtrLabel
#define AsmEmitJsleqlabel AsmEmitJsleqLabel
#define AsmEmitJslesslabel AsmEmitJslessLabel
#define AsmEmitJumplabel AsmEmitJumpLabel
#define AsmEmitJzerlabel AsmEmitJzerLabel

#define AsmEmitJeqLABEL AsmEmitJeqLabel
#define AsmEmitJgeqLABEL AsmEmitJgeqLabel
#define AsmEmitJgrtrLABEL AsmEmitJgrtrLabel
#define AsmEmitJleqLABEL AsmEmitJleqLabel
#define AsmEmitJlessLABEL AsmEmitJlessLabel
#define AsmEmitJneqLABEL AsmEmitJneqLabel
#define AsmEmitJnzLABEL AsmEmitJnzLabel
#define AsmEmitJsgeqLABEL AsmEmitJsgeqLabel
#define AsmEmitJsgrtrLABEL AsmEmitJsgrtrLabel
#define AsmEmitJsleqLABEL AsmEmitJsleqLabel
#define AsmEmitJslessLABEL AsmEmitJslessLabel
#define AsmEmitJumpLABEL AsmEmitJumpLabel
#define AsmEmitJzerLABEL AsmEmitJzerLabel

// This is required as otherwise:
//   
//   @emit Jump.Label x
//   
// Would not generate the `#x` required, while all other versions would.
#define AsmEmitJeqLabel(ctx,%2) AsmEmitJeqLabelStringize(ctx,#%2)
#define AsmEmitJgeqLabel(ctx,%2) AsmEmitJgeqLabelStringize(ctx,#%2)
#define AsmEmitJgrtrLabel(ctx,%2) AsmEmitJgrtrLabelStringize(ctx,#%2)
#define AsmEmitJleqLabel(ctx,%2) AsmEmitJleqLabelStringize(ctx,#%2)
#define AsmEmitJlessLabel(ctx,%2) AsmEmitJlessLabelStringize(ctx,#%2)
#define AsmEmitJneqLabel(ctx,%2) AsmEmitJneqLabelStringize(ctx,#%2)
#define AsmEmitJnzLabel(ctx,%2) AsmEmitJnzLabelStringize(ctx,#%2)
#define AsmEmitJsgeqLabel(ctx,%2) AsmEmitJsgeqLabelStringize(ctx,#%2)
#define AsmEmitJsgrtrLabel(ctx,%2) AsmEmitJsgrtrLabelStringize(ctx,#%2)
#define AsmEmitJsleqLabel(ctx,%2) AsmEmitJsleqLabelStringize(ctx,#%2)
#define AsmEmitJslessLabel(ctx,%2) AsmEmitJslessLabelStringize(ctx,#%2)
#define AsmEmitJumpLabel(ctx,%2) AsmEmitJumpLabelStringize(ctx,#%2)
#define AsmEmitJzerLabel(ctx,%2) AsmEmitJzerLabelStringize(ctx,#%2)

// Only used when they explicitly typed `@emit JUMP.label x:`
#define AsmEmitJeqlabelLabel AsmEmitJeqLabel
#define AsmEmitJgeqlabelLabel AsmEmitJgeqLabel
#define AsmEmitJgrtrlabelLabel AsmEmitJgrtrLabel
#define AsmEmitJleqlabelLabel AsmEmitJleqLabel
#define AsmEmitJlesslabelLabel AsmEmitJlessLabel
#define AsmEmitJneqlabelLabel AsmEmitJneqLabel
#define AsmEmitJnzlabelLabel AsmEmitJnzLabel
#define AsmEmitJsgeqlabelLabel AsmEmitJsgeqLabel
#define AsmEmitJsgrtrlabelLabel AsmEmitJsgrtrLabel
#define AsmEmitJsleqlabelLabel AsmEmitJsleqLabel
#define AsmEmitJslesslabelLabel AsmEmitJslessLabel
#define AsmEmitJumplabelLabel AsmEmitJumpLabel
#define AsmEmitJzerlabelLabel AsmEmitJzerLabel

#define AsmEmitJeqLABELLabel AsmEmitJeqLabel
#define AsmEmitJgeqLABELLabel AsmEmitJgeqLabel
#define AsmEmitJgrtrLABELLabel AsmEmitJgrtrLabel
#define AsmEmitJleqLABELLabel AsmEmitJleqLabel
#define AsmEmitJlessLABELLabel AsmEmitJlessLabel
#define AsmEmitJneqLABELLabel AsmEmitJneqLabel
#define AsmEmitJnzLABELLabel AsmEmitJnzLabel
#define AsmEmitJsgeqLABELLabel AsmEmitJsgeqLabel
#define AsmEmitJsgrtrLABELLabel AsmEmitJsgrtrLabel
#define AsmEmitJsleqLABELLabel AsmEmitJsleqLabel
#define AsmEmitJslessLABELLabel AsmEmitJslessLabel
#define AsmEmitJumpLABELLabel AsmEmitJumpLabel
#define AsmEmitJzerLABELLabel AsmEmitJzerLabel

#define AsmEmitJeqLabelLabel AsmEmitJeqLabel
#define AsmEmitJgeqLabelLabel AsmEmitJgeqLabel
#define AsmEmitJgrtrLabelLabel AsmEmitJgrtrLabel
#define AsmEmitJleqLabelLabel AsmEmitJleqLabel
#define AsmEmitJlessLabelLabel AsmEmitJlessLabel
#define AsmEmitJneqLabelLabel AsmEmitJneqLabel
#define AsmEmitJnzLabelLabel AsmEmitJnzLabel
#define AsmEmitJsgeqLabelLabel AsmEmitJsgeqLabel
#define AsmEmitJsgrtrLabelLabel AsmEmitJsgrtrLabel
#define AsmEmitJsleqLabelLabel AsmEmitJsleqLabel
#define AsmEmitJslessLabelLabel AsmEmitJslessLabel
#define AsmEmitJumpLabelLabel AsmEmitJumpLabel
#define AsmEmitJzerLabelLabel AsmEmitJzerLabel

// CallLabel macros.
#define asm_emit_callLabel AsmEmitCallLabel
#define asm_emit_call_labelLabel AsmEmitCallLabel
#define asm_emit_call_label AsmEmitCallLabel
#define asm_emit_CALLLabel AsmEmitCallLabel
#define asm_emit_CallLabel AsmEmitCallLabel
#define AsmEmitCalllabel AsmEmitCallLabel
#define AsmEmitCallLABEL AsmEmitCallLabel
#define AsmEmitCalllabelLabel AsmEmitCallLabel
#define AsmEmitCallLABELLabel AsmEmitCallLabel
#define AsmEmitCallLabelLabel AsmEmitCallLabel
#define AsmEmitCallLabel(ctx,%2) AsmEmitCallLabelStringize(ctx,#%2)

// Explicit `@emit Label name`
#define asm_emit_labelLabel(ctx,%2) AsmEmitLabelStringize(ctx,#%2)
#define asm_emit_LABELLabel(ctx,%2) AsmEmitLabelStringize(ctx,#%2)
#define asm_emit_LabelLabel(ctx,%2) AsmEmitLabelStringize(ctx,#%2)
#define asm_emit_label(ctx,%2) AsmEmitLabelStringize(ctx,#%2)
#define asm_emit_LABEL(ctx,%2) AsmEmitLabelStringize(ctx,#%2)
#define asm_emit_Label(ctx,%2) AsmEmitLabelStringize(ctx,#%2)

